import type { Config } from 'tailwindcss'

const config: Config = {
  darkMode: 'class',
  content: [
    './app/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
    './lib/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      colors: {
        accent: 'hsl(var(--accent) / <alpha-value>)',
      },
      boxShadow: {
        dock: '0 10px 30px rgba(0,0,0,0.35)',
      },
      backdropBlur: {
        mac: '20px',
      },
      borderRadius: {
        mac: '18px',
      },
      keyframes: {
        blob: {
          '0%': { transform: 'translate(0px, 0px) scale(1)' },
          '33%': { transform: 'translate(30px, -20px) scale(1.1)' },
          '66%': { transform: 'translate(-20px, 20px) scale(0.9)' },
          '100%': { transform: 'translate(0px, 0px) scale(1)' },
        },
        float: {
          '0%': { transform: 'translateY(0px)' },
          '50%': { transform: 'translateY(-6px)' },
          '100%': { transform: 'translateY(0px)' },
        },
        shimmer: {
          '0%': { backgroundPosition: '0% 50%' },
          '100%': { backgroundPosition: '200% 50%' },
        },
        dockBounce: {
          '0%': { transform: 'translateY(0)' },
          '20%': { transform: 'translateY(-14%)' },
          '40%': { transform: 'translateY(0)' },
          '60%': { transform: 'translateY(-8%)' },
          '80%': { transform: 'translateY(0)' },
          '100%': { transform: 'translateY(-4%)' },
        },
      },
      animation: {
        blob: 'blob 12s ease-in-out infinite',
        blobSlow: 'blob 18s ease-in-out infinite',
        float: 'float 6s ease-in-out infinite',
        shimmer: 'shimmer 2.2s linear infinite',
        dockBounce: 'dockBounce 600ms cubic-bezier(.34,1.56,.64,1)',
      },
      backgroundSize: {
        'shimmer': '200% 100%',
      },
    },
  },
  plugins: [],
}
export default config
