import * as React from 'react'

const SKILLS = {
  Languages: ['TypeScript', 'JavaScript', 'Python', 'Go'],
  Frameworks: ['Next.js', 'React', 'Node.js', 'Tailwind CSS'],
  Tools: ['Git', 'Docker', 'Linux', 'VS Code'],
} as const

export default function SkillsApp() {
  return (
    <div className="p-4 text-sm">
      <h2 className="text-lg font-semibold mb-4">Skills</h2>
      <div className="grid grid-cols-1 sm:grid-cols-3 gap-4">
        {Object.entries(SKILLS).map(([cat, items]) => (
          <div key={cat}>
            <h3 className="font-medium mb-2">{cat}</h3>
            <ul className="space-y-1">
              {items.map((s) => (
                <li
                  key={s}
                  className="rounded bg-black/5 dark:bg-white/5 px-2 py-1"
                >
                  {s}
                </li>
              ))}
            </ul>
          </div>
        ))}
      </div>
    </div>
  )
}
