import { projects } from "@/data/projects";

export default function ProjectsApp() {
  return (
    <div className="p-4 text-sm text-zinc-800 dark:text-zinc-100">
      <h2 className="text-lg font-semibold mb-3">Projects</h2>
      <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3">
        {projects.map((p) => (
          <div
            key={p.title}
            className="group rounded-xl border border-black/10 dark:border-white/10 p-3 bg-white/70 dark:bg-zinc-900/70 hover:bg-white dark:hover:bg-zinc-900 transition-colors"
          >
            <div className="flex items-start justify-between gap-2">
              <div className="font-medium group-hover:text-accent">{p.title}</div>
              <span className="text-[10px] px-1.5 py-0.5 rounded bg-black/5 dark:bg-white/10">{p.tag}</span>
            </div>
            <p className="mt-1 text-xs text-zinc-600 dark:text-zinc-300">{p.description}</p>
          </div>
        ))}
      </div>
    </div>
  );
}
