"use client";
import { useEffect, useState } from "react";

const KEY = "notes-content-v1";

export default function NotesApp() {
  const [text, setText] = useState("");
  const [savedAt, setSavedAt] = useState<string | null>(null);

  useEffect(() => {
    try {
      const v = localStorage.getItem(KEY);
      if (v != null) setText(v);
    } catch {}
  }, []);

  useEffect(() => {
    const id = setTimeout(() => {
      try {
        localStorage.setItem(KEY, text);
        setSavedAt(new Date().toLocaleTimeString());
      } catch {}
    }, 400);
    return () => clearTimeout(id);
  }, [text]);

  return (
    <div className="p-0 grid grid-cols-2 gap-0 h-full">
      <div className="p-3 border-r border-black/5 dark:border-white/5">
        <div className="text-xs text-zinc-500 mb-2">Write notes (auto-saves)</div>
        <textarea
          value={text}
          onChange={(e) => setText(e.target.value)}
          className="w-full h-[calc(100%-1.5rem)] resize-none outline-none bg-transparent text-sm text-zinc-800 dark:text-zinc-100"
          placeholder="Type your notes here..."
        />
      </div>
      <div className="p-3">
        <div className="text-xs text-zinc-500 mb-2 flex items-center justify-between">
          <span>Preview</span>
          <span>{savedAt ? `Saved ${savedAt}` : ""}</span>
        </div>
        <div className="prose prose-sm dark:prose-invert max-w-none">
          <pre className="whitespace-pre-wrap text-sm">{text || "Nothing yet..."}</pre>
        </div>
      </div>
    </div>
  );
}
