"use client";
import * as React from 'react'
import clsx from 'clsx'

const EMAIL = 'contact@guqc.me'
const SOCIALS = [
  { label: 'GitHub', href: 'https://github.com/your-handle', icon: GitHubIcon },
  { label: 'LinkedIn', href: 'https://linkedin.com/in/your-handle', icon: LinkedInIcon },
  { label: 'X', href: 'https://x.com/your-handle', icon: XIcon },
]

export default function ContactApp() {
  const [mounted, setMounted] = React.useState(false)
  const [copied, setCopied] = React.useState(false)
  React.useEffect(() => setMounted(true), [])

  const copy = async () => {
    try {
      await navigator.clipboard.writeText(EMAIL)
      setCopied(true)
      setTimeout(() => setCopied(false), 1500)
    } catch {}
  }

  return (
    <div className={clsx(
      'p-4 text-sm',
      mounted ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-1',
      'transition-all duration-300 ease-out motion-reduce:transition-none'
    )}>
      <h2 className="text-lg font-semibold mb-4">Contact</h2>

      {/* Email CTA */}
      <div className="flex flex-wrap items-center gap-3 mb-5">
        <a
          href={`mailto:${EMAIL}`}
          className={clsx(
            'inline-flex items-center gap-2 rounded-full px-4 py-2 text-sm font-medium',
            'bg-gradient-to-r from-fuchsia-500 via-purple-500 to-indigo-500 text-white',
            'shadow-md hover:shadow-lg focus:outline-none focus-visible:ring-2 focus-visible:ring-white/60'
          )}
        >
          <MailIcon className="h-4 w-4" />
          <span>Email me</span>
        </a>
        <button
          onClick={copy}
          className="inline-flex items-center gap-2 rounded-full px-3 py-2 text-sm font-medium bg-black/5 dark:bg-white/10 hover:bg-black/10 dark:hover:bg-white/15 text-zinc-800 dark:text-zinc-100 focus:outline-none focus-visible:ring-2 focus-visible:ring-accent/60"
          title={EMAIL}
        >
          {copied ? <CheckIcon className="h-4 w-4" /> : <CopyIcon className="h-4 w-4" />}
          {copied ? 'Copied' : EMAIL}
        </button>
      </div>

      {/* Socials */}
      <div>
        <p className="font-medium mb-2">Social</p>
        <ul className="flex flex-wrap gap-2">
          {SOCIALS.map((s) => {
            const Icon = s.icon
            return (
              <li key={s.label}>
                <a
                  href={s.href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="inline-flex items-center gap-2 rounded-full px-3 py-1.5 text-sm bg-black/5 dark:bg-white/10 hover:bg-black/10 dark:hover:bg-white/15 text-zinc-800 dark:text-zinc-100 shadow-sm hover:shadow focus:outline-none focus-visible:ring-2 focus-visible:ring-accent/60 transition-all duration-200"
                >
                  <Icon className="h-4 w-4" />
                  {s.label}
                </a>
              </li>
            )
          })}
        </ul>
      </div>
    </div>
  )
}

function MailIcon(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="1.5" aria-hidden="true" {...props}>
      <rect x="3" y="5" width="18" height="14" rx="2" />
      <path d="M3 7l9 6 9-6" />
    </svg>
  )
}
function CopyIcon(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="1.5" aria-hidden="true" {...props}>
      <rect x="9" y="9" width="13" height="13" rx="2" />
      <rect x="2" y="2" width="13" height="13" rx="2" />
    </svg>
  )
}
function CheckIcon(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" aria-hidden="true" {...props}>
      <path d="M20 6L9 17l-5-5" />
    </svg>
  )
}
function GitHubIcon(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" {...props}>
      <path d="M12 .5a12 12 0 0 0-3.79 23.39c.6.11.82-.26.82-.58v-2.02c-3.34.73-4.04-1.61-4.04-1.61-.55-1.4-1.34-1.77-1.34-1.77-1.1-.75.08-.73.08-.73 1.22.09 1.86 1.26 1.86 1.26 1.08 1.85 2.82 1.31 3.5 1 .11-.78.42-1.31.76-1.61-2.67-.3-5.48-1.34-5.48-5.95 0-1.31.47-2.37 1.24-3.2-.12-.3-.54-1.52.12-3.17 0 0 1.01-.32 3.3 1.23a11.4 11.4 0 0 1 6 0c2.28-1.55 3.29-1.23 3.29-1.23.66 1.65.24 2.87.12 3.17.77.83 1.24 1.89 1.24 3.2 0 4.62-2.8 5.64-5.48 5.94.43.37.81 1.1.81 2.22v3.29c0 .32.22.69.82.58A12 12 0 0 0 12 .5Z"/>
    </svg>
  )
}
function LinkedInIcon(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" {...props}>
      <path d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1s2.48 1.12 2.48 2.5zM.5 8.5h4V24h-4V8.5zM8 8.5h3.8v2.1h.05c.53-1 1.85-2.1 3.8-2.1 4.06 0 4.8 2.67 4.8 6.14V24h-4v-6.72c0-1.6-.03-3.67-2.24-3.67-2.24 0-2.58 1.74-2.58 3.55V24h-4V8.5z"/>
    </svg>
  )
}
function XIcon(props: React.SVGProps<SVGSVGElement>) {
  return (
    <svg viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" {...props}>
      <path d="M18.244 2H21l-6.588 7.52L22 22h-6.59l-4.61-6.06L4.5 22H2l7.105-8.11L2 2h6.59l4.12 5.43L18.244 2Zm-2.31 18h2.146L8.254 4H6.106l9.828 16Z"/>
    </svg>
  )
}
