export default function AboutApp() {
  return (
    <div className="p-4 text-sm text-zinc-800 dark:text-zinc-100">
      <div className="flex items-center gap-4">
        <div className="size-16 rounded-2xl bg-gradient-to-br from-purple-400 to-blue-500" />
        <div>
          <h2 className="text-xl font-semibold tracking-tight">Void</h2>
          <p className="text-zinc-600 dark:text-zinc-300">Building a macOS‑styled portfolio. Minimal, smooth, and modern.</p>
          <div className="mt-2 flex gap-3 text-zinc-700 dark:text-zinc-300">
            <a className="underline underline-offset-2 hover:text-accent" href="mailto:contact@guqc.me">contact@guqc.me</a>
            {/* TODO: add GitHub/LinkedIn/Discord links when provided */}
          </div>
        </div>
      </div>

      <div className="mt-6 grid gap-3 text-zinc-700 dark:text-zinc-200">
        <p>
          Welcome! This portfolio is themed like macOS Monterey with a Menu Bar, Dock,
          and draggable app windows. Use the Dock to open the Python Editor and Projects.
        </p>
        <p>
          Theme can follow your system setting or be switched manually from the Menu Bar (Auto/Light/Dark).
        </p>
      </div>
    </div>
  );
}
