"use client";
import { useEffect, useMemo, useState } from "react";
import { useTheme } from "next-themes";
import { useWindowStore } from "@/lib/windowStore";

function Clock() {
  const [now, setNow] = useState<string>("");
  useEffect(() => {
    const update = () => {
      const d = new Date();
      const fmt = new Intl.DateTimeFormat(undefined, {
        weekday: "short",
        hour: "2-digit",
        minute: "2-digit",
      });
      setNow(fmt.format(d));
    };
    update();
    const id = setInterval(update, 15_000);
    return () => clearInterval(id);
  }, []);
  return <span className="tabular-nums text-sm tracking-tight">{now}</span>;
}

export default function MenuBar() {
  const { theme, setTheme, systemTheme } = useTheme();
  const focusedTitle = useWindowStore(
    useMemo(
      () => (s) => {
        let maxZ = -Infinity;
        let title = "Finder";
        Object.values(s.windows).forEach((w) => {
          if (w && !w.minimized && w.z > maxZ) {
            maxZ = w.z;
            title = w.title;
          }
        });
        return title;
      },
      []
    )
  );

  const activeTheme = theme === "system" ? systemTheme : theme;

  return (
    <div className="fixed inset-x-0 top-0 z-[1000]">
      <div className="glass h-8 flex items-center justify-between px-3 text-sm text-zinc-900 dark:text-zinc-100 select-none border-b border-black/5 dark:border-white/5">
        <div className="flex items-center gap-3">
          <span className="text-lg"></span>
          <span className="font-semibold">{focusedTitle}</span>
        </div>
        <div className="flex items-center gap-4">
          <div className="flex items-center gap-1">
            <button
              className={`px-2 py-0.5 rounded hover:bg-black/5 dark:hover:bg-white/10 ${theme === "system" ? "font-semibold" : ""}`}
              onClick={() => setTheme("system")}
              aria-pressed={theme === "system"}
              title="Use system theme"
            >
              Auto
            </button>
            <button
              className={`px-2 py-0.5 rounded hover:bg-black/5 dark:hover:bg-white/10 ${activeTheme === "light" ? "font-semibold" : ""}`}
              onClick={() => setTheme("light")}
              aria-pressed={activeTheme === "light"}
              title="Light theme"
            >
              Light
            </button>
            <button
              className={`px-2 py-0.5 rounded hover:bg-black/5 dark:hover:bg-white/10 ${activeTheme === "dark" ? "font-semibold" : ""}`}
              onClick={() => setTheme("dark")}
              aria-pressed={activeTheme === "dark"}
              title="Dark theme"
            >
              Dark
            </button>
          </div>
          <Clock />
        </div>
      </div>
    </div>
  );
}
