"use client";
import * as React from "react";
import clsx from "clsx";

/**
 * BackgroundFX
 * Animated gradient blobs behind the desktop. GPU-friendly (transform/opacity only),
 * uses CSS motion-safe to respect reduced-motion without JS.
 */
export default function BackgroundFX() {

  return (
    <div
      aria-hidden
      className="pointer-events-none fixed inset-0 z-0 overflow-hidden"
    >
      {/* Static subtle gradient base to avoid hard flashes */}
      <div className={clsx(
        "absolute inset-0",
        "bg-gradient-to-b from-[#2b2b2b] to-[#0b0b0b] dark:from-[#0b0b0b] dark:to-black"
      )} />

      {/* Animated blobs layer (respects reduced motion via CSS) */}
      <Blob className="left-[5%] top-[10%] bg-[radial-gradient(circle_at_center,rgba(143,92,245,0.45),transparent_60%)]" size={680} delay={0} slow />
      <Blob className="right-[0%] top-[-10%] bg-[radial-gradient(circle_at_center,rgba(62,113,255,0.40),transparent_60%)]" size={820} delay={3} />
      <Blob className="left-[20%] bottom-[-10%] bg-[radial-gradient(circle_at_center,rgba(255,99,132,0.25),transparent_60%)]" size={720} delay={6} />
    </div>
  );
}

function Blob({ className, size = 700, delay = 0, slow = false }: { className?: string; size?: number; delay?: number; slow?: boolean }) {
  return (
    <div
      className={clsx(
        "absolute will-change-transform",
        slow ? "motion-safe:animate-blobSlow" : "motion-safe:animate-blob",
        className
      )}
      style={{
        width: size,
        height: size,
        filter: "blur(40px)",
        transformOrigin: "center",
        animationDelay: `${delay}s`,
      }}
    />
  );
}
