import './globals.css'
import type { Metadata } from 'next'
import ThemeProvider from './providers/ThemeProvider'

export const metadata: Metadata = {
  title: 'Void — macOS Portfolio',
  description: 'A macOS Monterey–styled portfolio desktop',
}

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body className="min-h-screen body-bg">
        <ThemeProvider>{children}</ThemeProvider>
      </body>
    </html>
  )
}
