# macOS Monterey–styled Portfolio

A personal portfolio themed like the macOS desktop (Monterey): Menu Bar, Dock with hover magnification, draggable windows with traffic lights, and initial apps (About, Notes, Projects). Built with Next.js (App Router) + Tailwind CSS. Theme supports Auto (system), Light, and Dark.

## Stack
- Next.js 14 (App Router)
- React 18 + TypeScript
- Tailwind CSS
- next-themes (system/manual theme switching)
- Zustand (window manager)

## Features
- Menu Bar: app title, theme controls (Auto/Light/Dark), live clock.
- Dock: hover magnification, indicators, click to open/focus/minimize.
- App Windows: draggable, focus z-order, minimize/close, translucent header.
- Apps:
  - About: name + contact links.
  - Notes: autosaving textarea with preview; persists in localStorage.
  - Projects: simple card grid sourced from `data/projects.ts`.
- Monterey-ish gradient background and system font stack (uses SF on macOS).

## Getting Started

1. Install dependencies
```bash
npm install
```

2. Run the dev server
```bash
npm run dev
```
Open http://localhost:3000

3. Build & start
```bash
npm run build
npm start
```

## Customization

- About app content: `components/apps/About.tsx`
  - Replace name, bio, and add social links (GitHub, LinkedIn, Discord, etc.).
- Projects data: `data/projects.ts`
  - Fill real projects with `title`, `description`, `link`, optional `tag`.
- Notes storage key: `components/apps/Notes.tsx` (constant `KEY`).
- Theme defaults: `app/providers/ThemeProvider.tsx` (default is `system`).
- Colors/blur/background: `app/globals.css` and Tailwind theme in `tailwind.config.ts`.

## Accessibility
- Dock magnification respects `prefers-reduced-motion` and disables the effect when enabled.
- Uses semantic roles and labels for window controls.

## Deploy to Vercel

1. Push to a Git repo (GitHub/GitLab/Bitbucket).
2. In Vercel, create a New Project and import the repo.
3. Framework preset: Next.js; defaults are fine.
4. Deploy. Vercel will build with `npm install` and `npm run build`.

## Roadmap
- Add more apps: Terminal (fun commands), Settings (wallpaper/theme/accent), Discord presence panel.
- Window resizing, snap to edges, and remember positions.
- Desktop icons and right-click menu.

## License & Assets
- Uses a system font stack; does not bundle SF Pro.
- Icons are simple inline SVGs styled to resemble macOS app glyphs; replace with your own if desired.
